#include <stdlib.h>
#include "Report.h"

ReportDataList newReportDataList(Macchina *m, PartiList listaParti, 
                                 ReportDataList resto)
{
    ReportDataList lista = (ReportDataList)malloc(sizeof(ReportData));
    lista->macchina = m;
    lista->listParti = listaParti;
    lista->next = resto;
    return lista;
}

void destroyReportDataList(ReportDataList lista)
{
    if (lista != NULL)
    {
        destroyReportDataList(lista->next);
        destroyPartiList(lista->listParti, false);
        free(lista);
    }
}

void addParteToReportData(ReportData *rd, Parte *p)
{
    rd->listParti = newPartiList(p, rd->listParti);
}

ReportData* getNextReportData(ReportData* rd)
{
    return rd->next;
}

ReportDataList groupMacchineParti(list listaMacchine, PartiList listaParti)
{
    ReportDataList rdl = NULL;
    while (!empty(listaMacchine))
    {
        Macchina *m = head(listaMacchine);
        PartiList pl = listaParti;
        rdl = newReportDataList(m, NULL, rdl);

        while (pl != NULL)
        {
            if (m->id == pl->parte->idMacchina)
                addParteToReportData(rdl, pl->parte);
            pl = getNextPartiListItem(pl);
        }

        listaMacchine = tail(listaMacchine);
    }
    return rdl;
}


void saveReport(FILE *f, ReportDataList reportList)
{
    while (reportList != NULL)
    {
        PartiList pl;
        fprintf(f, "%d %s\n", reportList->macchina->id, 
            reportList->macchina->nome);
        pl = reportList->listParti;
        while (pl != NULL)
        {
            fprintf(f, "\t%d %s %d\n", pl->parte->id, pl->parte->nome,
                pl->parte->costo);
            pl = getNextPartiListItem(pl);
        }
        fprintf(f, "Numero Parti: %d -- Costo Totale: %d\n\n",
            getPartiCount(reportList->listParti),
            getTotalCost(reportList->listParti));
        reportList = getNextReportData(reportList);
    }
}