#include <stdlib.h>
#include "PartiList.h"

PartiList getEmptyPartiList()
{
    return NULL;
}

PartiList newPartiList(Parte *p, PartiList rest)
{
    PartiList pl = (PartiList)malloc(sizeof(PartiListItem));
    pl->parte = p;
    pl->next = rest;
    return pl;
}

void destroyPartiList(PartiList pl, boolean destroyInnerParti)
{
    if (pl != NULL)
    {
        destroyPartiList(pl->next, destroyInnerParti);
        if (destroyInnerParti)
            destoryParte(pl->parte);
        free(pl);
    }
}

PartiListItem* getNextPartiListItem(PartiListItem *listItem)
{
    return listItem->next;
}

int getPartiCount(PartiList pl)
{
    int i = 0;
    while (pl != NULL)
    {
        i++;
        pl = getNextPartiListItem(pl);
    }
    return i;
}

int getTotalCost(PartiList pl)
{
    int costo = 0;
    while (pl != NULL)
    {
        costo += pl->parte->costo;
        pl = getNextPartiListItem(pl);
    }
    return costo;
}


