#include "DataRead.h"

void readField(FILE *f, char buffer[], char separator)
{
    char readChar;
    int i;

    for (i = 0, readChar = fgetc(f); 
        readChar != separator && readChar != EOF;
        i++, readChar = fgetc(f))
    {
        buffer[i] = readChar;
    }

    buffer[i] = '\0';
}

Macchina* readMacchinaFromFile(FILE *f)
{
    int id;
    char nome[MAXNOME];
    Macchina *m;

    fscanf(f, "%d ", &id);
    //fgetc(f);
    readField(f, nome, '\n');

    m = newMacchina(id, nome);
    return m;
}

Parte* readParteFromFile(FILE *f)
{
    int id, idMacchina, costo;
    char nome[MAXNOME];
    Parte *p;

    fscanf(f, "%d %d ", &id, &idMacchina);
    readField(f, nome, ';');
    fscanf(f, "%d\n", &costo);

    p = newParte(id, idMacchina, nome, costo);
    return p;
}

void skipLine(FILE *f)
{
    char readChar;
    do
    {
        readChar = fgetc(f);
    }
    while (readChar != '\n' && readChar != EOF);
}

list readMacchineFromFile(FILE *f)
{
    list macchineList = emptylist();
    char readChar = fgetc(f);
    while (readChar != EOF)
    {
        if (readChar == 'M')
        {
            Macchina *m = readMacchinaFromFile(f);
            macchineList = cons(m, macchineList);
        }
        else
        {
            skipLine(f);
        }
        readChar = fgetc(f);
    }
    return macchineList;
}

PartiList readPartiFromFile(FILE *f)
{
    PartiList partiList = getEmptyPartiList();
    char readChar = fgetc(f);
    while (readChar != EOF)
    {
        if (readChar == 'P')
        {
            Parte *p = readParteFromFile(f);
            partiList = newPartiList(p, partiList);
        }
        else
        {
            skipLine(f);
        }
        readChar = fgetc(f);
    }
    return partiList;
}
