#include "function.h"


double sommaSpese(int codice, ComE *e, int dimE)
{
	double somma = 0.0, media = 0.0;
	int sommamedia = 0, count = 0;
	int i = 0;
	
	for (i=0;i<dimE;i++)
		if(e[i].codice == codice)
		{
		    sommamedia += e[i].importo;
		    count++;
			
			if(e[i].importo<5000)
				somma += (e[i].importo)*0.9;
			else
				somma += (e[i].importo)*0.88;
		}
		
	media = (double)sommamedia / (double) count;
	printf("\nLa media degli importi per il condominio %d risulta: %lf\n", codice, media);
	return somma;
}

void insert(char* fileName, char type)
{
	
	ComE e;
	ComE  temp;
	ComA a;
	FILE *f;
	char id;
	char trash[100];

		
	if(type == 'A')
	{
		printf("Inserire il codice Condominio:");
		scanf("%d%*c",&a.codice);
		printf("Inserire la comunicazione:");
	//  gets(a.comunicazione);
		//si può usare benissimo gets, ma è più sicuro usare fgets, leggendo da input
		fgets(a.comunicazione,100,stdin);
		printf("\nInseririmento: %d %s \n", a.codice, a.comunicazione);
	}
	else if(type == 'E')
	{
		printf("Inserire il codice Condominio:");
		scanf("%d%*c",&e.codice);
		printf("Inserire la comunicazione:");
		scanf("%s%*c",e.comunicazione);
		printf("Inserire l'importo:");
		scanf("%d%*c",&e.importo);
		printf("Inserire l'anno:");
		scanf("%d%*c",&e.anno);
		printf("Inserire il mese:");
		scanf("%d%*c",&e.mese);
		printf("Inserire il giorno:");
		scanf("%d%*c",&e.giorno);
		
		printf("\nInseririmento: %d imp: %d %s %d-%d-%d\n", e.codice,e.importo, e.comunicazione,e.anno,e.mese,e.giorno);
		
		
		if ((f=fopen(fileName, "r"))==NULL)
		{
			printf("errore in apertura file %s", fileName);
			exit(-1);
		}
		
		while(fscanf(f,"%c",&id)>0)
		{
			if (id=='E')
			{			
				fscanf(f,"%d %d %s %d %d %d", &temp.codice, &temp.importo, temp.comunicazione, &temp.anno, &temp.mese, &temp.giorno);
				
				if((temp.anno == e.anno)
					&&(temp.mese == e.mese)
						&&(temp.giorno == e.giorno)
							&&(strcmp(temp.comunicazione,e.comunicazione)==0))
								{
									printf("errore comunicazione già presente");
									exit(-1);	
								}
			}
			else
				fgets(trash,100,f);
		}
		
		fclose(f);
	}
	else 
	{
		printf("errore, tipo comunicazione inesistente");
		exit(1);
	}
	
	printf("Apertura File %s\n", fileName);
	if ((f=fopen(fileName, "a"))==NULL)
		{
			printf("errore in apertura file %s", fileName);
			exit(-1);
		}
	
	if(type == 'A')
		fprintf(f,"A %d %s",a.codice,a.comunicazione);
	else 
		fprintf(f,"E %d %d %s %d %d %d",e.codice,e.importo,e.comunicazione,e.anno,e.mese,e.giorno);
	
	
	
	fclose(f);
}